<?php defined( 'DASHBOARD_MOD_DIR' ) OR DIE; ?>

<!-- ======== sidebar-nav start =========== -->

<aside class="sidebar-nav-wrapper">

	<div class="navbar-logo">
		<a href="<?php echo core::url( ROOT_DIR ) . "/" . uss::query(0); ?>">
			<img src="<?php echo uss::$global['icon']; ?>" height='50px' alt="logo" />
		</a>
	</div>
	
	<nav class="sidebar-nav text-capitalize">
		<ul id='nav-group'>
			<?php 

				uss::$global['menu']->iterate(function($menu, $closure) {

					if( empty($menu->get_attr('label')) || $menu->level > 3 ) return;

					$menu_id = $menu->get_attr('id') ?? "menu-{$menu->level}-{$menu->name}";

					# For <li/>

					$li_attr = array( 
						"class" => !$menu->level ? 'nav-item' : 'nav-sub-item',
						"data-menu-level" => $menu->level
					);
					
					$active = !empty($menu->get_attr('active'));
					
					if( $active ) $li_attr['class'] .= ' active';
						
					if( !empty($menu->child) && $menu->level < 3 ) {
						
						$li_attr['class'] .= " nav-item-has-children";
						
						$anchor_attr = array(
							"href" => 'javascript:void(0)',
							'class' => !$active ? 'collapsed' : null,
							'data-bs-toggle' => 'collapse',
							'data-bs-target' => "#{$menu_id}",
							'aria-controls' => $menu_id,
							'aria-expanded' => 'false'
						);
						
					} else $anchor_attr = array( 'href' => $menu->get_attr('href') ?? 'javascript:void(0)' );
					
					$parent = empty($menu->level) ? "data-bs-parent='#nav-group'" : null;

				?>

			<li <?php echo core::array_to_html_attrs($li_attr); ?>>
			
				<a <?php echo core::array_to_html_attrs($anchor_attr); ?>>
					<?php if( empty($menu->level) ): ?>
						<span class="icon"><?php echo $menu->get_attr('icon'); ?></span>
					<?php endif; ?>
					<span class="text"><?php echo $menu->get_attr('label'); ?></span>
				</a>
				
				<?php if( !empty($menu->child) ): ?>
				<ul id='<?php echo $menu_id; ?>' class='collapse dropdown-nav <?php if( $active ) echo 'show'; ?>' <?php echo $parent; ?>>
					<?php $menu->iterate( $closure, true ); ?>
				</ul>
				<?php endif; ?>
				
			</li>
			
			<?php if( !empty($menu->get_attr('hr')) ): ?>
				<span class="divider"><hr/></span>
			<?php endif; ?>
			
			<?php
				}, true); // end menu;
			?>
			
		</ul>
	</nav>
	
</aside>

<div class="overlay">
	<a href='javascript:void(0)' class='overlay-close'>	
		<i class='lni lni-close'></i>
	</a>
</div>

<!-- ======== sidebar-nav end =========== -->