<?php defined( 'DASHBOARD_MOD_DIR' ) OR DIE; ?>		
	<title><?php echo uss::htmlentities( uss::$global['title'] ); ?></title>
	<link rel='icon' href='<?php echo uss::$global['icon']; ?>'>
	<meta name='description' content='<?php echo uss::htmlentities( uss::$global['description'] ); ?>'>
	
	<?php
		
		$opengraph = array(
			'og:title' => 'title',
			'og:image' => 'icon',
			'og:description' => 'description'
		);
		
		foreach( $opengraph as $key => $alt ) 
			uss::$global['opengraph'][ $key ] = uss::$global['opengraph'][ $key ] ?? uss::$global[ $alt ];
			
		
		/* 
			Basic Open Graph Tags For SEO!
		
			[
				'og:url', 
				'og:type', 
				'og:locale',
				'og:determiner',
				'og:site_name',
				'og:video',
				'og:audio',
				'fb:app_id'
			]
			
		*/
		
		foreach( uss::$global['opengraph'] as $key => $value ):
		
			if( empty($value) ) continue;
			
			else if( is_array($value) ) {
				
				foreach( $value as $chunk ) {
					if( empty($chunk) ) continue;
					$chunk = uss::htmlentities( $chunk );
					echo "<meta name='{$key}' content='{$chunk}'>\n\t";
				}
				
			} else {
				$value = uss::htmlentities( $value );
				echo "<meta name='{$key}' content='{$value}'>\n\t";
			}
			
		endforeach; 
		
	?>
	