<?php
	
	defined( 'DASHBOARD_MOD_DIR' ) OR DIE;
	
	$notice = call_user_func(function() {
		
		$data = array();
		
		$prefix = DB_TABLE_PREFIX;
		$userid = uss::$global['user']['id'];
		$limit = 3;
		
		// Get Unviewed Number;
		
		$views = uss::$global['mysqli']->query( "
			SELECT COUNT(viewed) AS unviewed
			FROM {$prefix}_notifications
			WHERE userid = {$userid}
				AND viewed = 0
				AND hidden = 0
			GROUP BY userid
		" )->fetch_assoc();
		
		$data['alert'] = $views ? $views['unviewed'] : 0;
		
		// Show limited Notifications;
		
		$data['notify'] = uss::$global['mysqli']->query( "
			SELECT * FROM {$prefix}_notifications
			WHERE userid = {$userid}
				AND hidden = 0
			ORDER BY id DESC
			LIMIT {$limit} 
		" );
		
		return $data;
		
	});
	
	$notify_url = dashboard::config('page:notification');
	
?>
	<div class="notification-box ml-15">
		
		<div class='d-none d-sm-flex'>
			
			<?php 
				events::addListener( md5(':notix-btn!'), function($data) use($notice) {
					if( $data[0] == false ) {
						$attrs = array(
							'class' => "dropdown-toggle",
							'id' => "notification",
							'data-bs-toggle' => "dropdown", 
							'aria-expanded' => "false"
						);
					} else {
						$attrs = array( 
							'class' => 'mobile-notice' 
						);
					};
					$attrs = $attrs + array( 'type' => "button" );
			?>
				<button <?php echo core::array_to_html_attrs( $attrs ); ?>>
					<i class="lni lni-alarm"></i>
					<?php if( !empty($notice['alert']) ): ?>
						<span class='animate__animated animate__wobble animate__infinite' data-nx-count>
							<?php echo $notice['alert']; ?>
						</span>
					<?php endif; ?>
				</button>
			<?php }); ?>
			
			<?php 
				// do not attach an event to this listener;
				events::exec( md5(':notix-btn!'), [false] ); 
			?>
			
			<ul class="dropdown-menu dropdown-menu-end" aria-labelledby="notification" data-parse='nx'>
				<?php 
				
					while( $notification = $notice['notify']->fetch_assoc() ):
					
						$image = $notification['image'];
						
						if( empty($image) ) {
							$image = dashboard::call('user:avatar', $notification['origin']);
							if( empty($image) ) {
								$image = dashboard::call('user:avatar', $notification['userid']);
							};
						};
						
						$markdown = call_user_func(function() use($notification) {
							$text = str_replace(
								['<', '>'],
								['&lt;', '&gt;'],
								trim( $notification['message'] )
							);
							return (new Parsedown())->text( $text );
						});
						
						$len = 124;
						$message = trim( strip_tags( $markdown ) );
						$message = substr($message, 0, $len);
						
						if( strlen($notification['message']) > $len) $message .= "&hellip;";
						
						if( empty($notification['redirect']) ) 
							$notification['redirect'] = 'javascript:void(0)';
						
						$class = empty($notification['viewed']) ? 'unviewed' : null;
						
				?>
				<li>
					<a href="<?php echo $notification['redirect']; ?>" class='<?php echo $class; ?>' data-nx='<?php echo $notification['id']; ?>'>
						<div class="image">
							<img src="<?php echo $image; ?>" alt="" />
						</div>
						<div class="content">
							<p><?php echo $message; ?></p>
							<span><?php echo core::elapse( $notification['period'] ); ?></span>
						</div>
					</a>
				</li>
				<?php endwhile; ?>
				<li>
					<a href="<?php echo core::url( ROOT_DIR ) . "/" . $notify_url; ?>" class='d-block text-center'>
						<small> <i class='bi bi-bell me-1'></i> View all </small>
					</a>
				</li>
			</ul>
			
		</div>
		
		<div class='d-sm-none'>
			<a href='<?php echo core::url( ROOT_DIR ) . "/" . $notify_url; ?>'>
				<?php 
					// do not attach an event to this listener;
					events::exec( md5(':notix-btn!'), [true], null, function($key, $file) { 
						return ( core::rslash($file) === core::rslash(__FILE__) );
					}); 
				?>
			</a>
		</div>	
		
	</div>
	