<?php require_once __DIR__ . '/init.php';

$auth_container(function( $auth_url ) { ?>

	<div class="signin-wrapper">
		<div class="form-wrapper">
			
			<?php events::exec('dashboard.signin-form::above'); ?>
			
			<form method='post'action="<?php echo dashboard::config('auth_url') ?? $auth_url; ?>" id='auth-form' data-type='signin' enctype='multipart/form-data'>
				<div class="row py-3">
					<div class="col-sm-10 col-md-9 m-auto">
						
						<?php events::addListener('dashboard.signin-form::input', function() { ?>
							<div class="mb-3">
								<input type="text" placeholder="Login detail" class='form-control' name='login' required pattern="^\s*(?:\w+|(?:[^@]+@[a-zA-Z0-9\-_]+\.\w{2,}))\s*$">
							</div>
						<?php }, 'input-login'); ?>
							
						<?php events::addListener('dashboard.signin-form::input', function() { ?>
							<div class="mb-4">
								<input type="password" placeholder="Password" class='form-control' name='password' required pattern='^.{4,}$'>
							</div>
						<?php }, 'input-password'); ?>
							
						<?php 
							events::addListener('dashboard.signin-form::input', function() { 
								/*
									Remember Me: The option was removed!
								*/
						?>
							<div class='d-flex justify-content-between mb-3'>
								<div class='resend-email ms-auto'>
									<a href='javascript:void(0)' title="Resend Confirmation Email" data-vcode>
										<small>Reconfirm Email</small> <i class='mdi mdi-email-check'></i>
									</a>
								</div>
							</div>
						<?php }, 'input-reconfirm'); ?>
													
						<?php events::addListener('dashboard.signin-form::input', function() { ?>
							<div class="">
								<button class="btn btn-primary w-100" type='submit'>
									Sign In
								</button>
							</div>
						<?php }, 'input-submit'); ?>
							
						<?php events::exec('dashboard.signin-form::input', [], true); ?>
						
					</div>
				</div>
				<!-- end row -->
			</form>
			
			<?php 
				events::addListener('dashboard.signin-form::below', function() { 
					$disabled = !empty(uss::$global['options']->get('user:disable-signup'));
					if( $disabled ) return;
			?>
				<div class="mt-2">
					<p class="text-sm text-center">
						Don’t have an account yet? 
						<a href="<?php echo dashboard::config('location') . "/signup" ?>" class='text-nowrap'>
							Create an account
						</a>
					</p>
				</div>
			<?php }, 'account-signup'); ?>
			
			<?php events::addListener('dashboard.signin-form::below', function() { ?>
				<div class="mt-2">
					<p class="text-sm text-center">
						Forgot Password? 
						<a href="<?php echo dashboard::config('location') . "/reset"; ?>" class="hover-underline text-nowrap">
							Reset Password
						</a>
					</p>
				</div>
			<?php }, 'account-reset'); ?>
				
			<?php events::exec('dashboard.signin-form::below'); ?>
			
		</div>
	</div>

<?php }, '--auth-signin');