<?php  require_once __DIR__ . '/init.php';

$auth_container(function( $auth_url ) { ?>

	<div class="signin-wrapper">
		<div class="form-wrapper">
		
			<?php events::exec('dashboard.reset-form::above'); ?>
			
			<?php if( empty(uss::$global['reset']) ): ?>
			
				<form method='post' action="<?php echo dashboard::config('auth_url') ?? $auth_url; ?>" id='auth-form' data-type='reset' enctype='multipart/form-data'>
					<div class="row py-3">
						<div class="col-sm-10 col-md-9 m-auto">
							
							<?php events::addListener('dashboard.reset-form::input', function() { ?>
								<div class='text-center mb-3'>
									<small>You'll receive an email to continue the process</small>
								</div>
							<?php }, 'input-detail'); ?>
							
							<?php events::addListener('dashboard.reset-form::input', function() { ?>
								<div class="mb-3">
									<input type="email" name='email' placeholder="Email" class='form-control'>
								</div>
							<?php }, 'input-email'); ?>
							
							<?php events::addListener('dashboard.reset-form::input', function() { ?>
							<div class="">
								<button class="btn btn-primary w-100">
									Reset Password
								</button>
							</div>
							<?php }, 'input-submit'); ?>
							
							<?php events::exec('dashboard.reset-form::input'); ?>
							
						</div>
					</div>
					<!-- end row -->
				</form>
			
			<?php else: ?>
			
				<form method='post' action="<?php echo dashboard::config('auth_url') ?? $auth_url; ?>" id='auth-form' data-type='reset-approved' enctype='multipart/form-data'>
					<div class="row py-3">
						<div class="col-sm-10 col-md-9 m-auto">
							
							<?php events::addListener('dashboard.reset-form::input', function() { ?>
								<div class='text-center mb-3'>
									<small>Please enter your new password</small>
								</div>
							<?php }, 'input-detail'); ?>
							
							<?php events::addListener('dashboard.reset-form::input', function() { ?>
							
								<div class="mb-3">
									<input type="password" name='password' placeholder="Password" class='form-control' pattern='^.{4,}$' required>
								</div>
								
								<div class="mb-3">
									<input type="password" name='confirm_password' placeholder="Confirm Password" class='form-control' pattern='^.{4,}$'>
								</div>
								
								<input type='hidden' name='passport' value='<?php echo uss::$global['reset']; ?>'>
								<input type='hidden' name='nonce' value='<?php echo uss::nonce( $_SESSION['resetter'] ); ?>'>
								
							<?php }, 'input-password-group' ); ?>
							
							<?php events::addListener('dashboard.reset-form::input', function() { ?>
							<div class="">
								<button class="btn btn-primary w-100">
									Change Password
								</button>
							</div>
							<?php }, 'input-submit' ); ?>
							
							<?php events::exec('dashboard.reset-form::input'); ?>
							
						</div>
					</div>
					<!-- end row -->
				</form>

			
			<?php endif; ?>
			
			
			<?php events::addListener('?dashboard:reset-form::below', function() { ?>
			<div class="mt-4">
				<p class="text-sm text-medium text-dark text-center">
					Back To <a href="<?php echo dashboard::config('location'); ?>">Login</a>
				</p>
			</div>
			<?php }, 'account-signin'); ?>
			
			<?php events::exec('?dashboard:reset-form::below'); ?>
			
		</div>
	</div>
				  
<?php }, '--auth-reset');