<?php 

defined( 'DASHBOARD_MOD_DIR' ) OR DIE;

/*
	Add Sidebar Menu!
	Outside a focus path!
*/

$account = uss::$global['menu']->add('prospect', array(
	'label' => "Account",
	"icon" => "<i class='bi bi-person-bounding-box'></i>",
	"active" => uss::query(1) == 'account'
));


/*
	Add a submenu!
*/

$account->add('profile', array(
	"label" => "Profile",
	"href" => core::url( ROOT_DIR . '/' . ( $FOCUS = DASHBOARD_FOCUS_URI . "/account" ) )
))->set_attr( 'active', $_GET['query'] == $FOCUS );

/*
	- Add a new profile nav item!
	
	I.E! The dropdown at the TOP-RIGHT of the dashboard
*/

events::addListener(':profile-nav', function() use( $account ) { ?>
	<li>
		<a href="<?php echo $account->get('profile')->get_attr('href'); ?>">
			<i class="lni lni-user"></i> View Profile
		</a>
	</li>
<?php }, 'nav-user'); 



/*
	- Now! Create a Focus Path!
	
	- The code below will run only when the URL matches
	
	https://yourdomain.com/dashboard/account
	
*/

uss::focus( $FOCUS, function() {
	
	/*
		nonce key for security authentication!
	*/
	$nonce_key = "profile-" . ( uss::$global['user'] ? uss::$global['user']['id'] : null );
		
		
	// For handling the post request after submission!
	
	require __DIR__ . '/POST/profile.php';
	
	/*
		- Now let's create a dashboard view
	*/
	
	dashboard::view(function() use( $nonce_key ) { 
		
		/*
			Configuration option!
		*/
		$lockemail = !empty(uss::$global['options']->get('user:lock-email'));
		
		/*
			Dedicate a general name if username is absent!
		*/
		$username = uss::$global['user']['username'];
		if( empty($username) ) $username = 'Hi dear';
		
	?>
		
		<section class="section">
			<div class="container-fluid">
				<!-- ========== title-wrapper start ========== -->
				<div class="row">
					
					<?php 
						events::addListener('dashboard.account-row::before', function() {
							$affiliate = uss::$global['options']->get('user:affiliation');
							if( !$affiliate ) return;
							$link = core::url( ROOT_DIR . "/" . DASHBOARD_FOCUS_URI ) . "/signup?ref=" . uss::$global['user']['usercode'];
					?>
							<div class='col-12 mb-3'>
								<div class='row flex-wrap align-items-center justify-content-end'>
									<div class='d-nonde d-sm-block col-sm-4 col-md-6 mb-1'>
										<p class='fs-16px text-sm-end mb-0 fw-light'>
											<span class='text-primary'>My</span> 
											<span class='text-success'>referral</span> 
											<span class='text-danger'>link</span> 
											&mdash; <i class='bi bi-people'></i>
										</p>
									</div>
									<div class='col-sm-8 col-md-6'>
										<div class='input-group'>
											<input type='text' class='form-control form-control-lg text-sm' readonly value='<?php echo $link; ?>' id='reflink'>
											<button class='btn btn-info' data-uss-copy='#reflink'>
												<i class='bi bi-clipboard'></i>
											</button>
										</div>
									</div>
								</div>
							</div>
					<?php }); ?>
					
					<?php events::exec('dashboard.account-row::before'); ?>
					
					<div class="<?php echo dashboard::config('@class=dashboard.account:col-left') ?? 'col-lg-5'; ?>">
					
						<div class="card settings-card-1 mb-30">
							<div class='card-body'>
								
								<div class='p-3'>
								
									<div class="profile-info">
									
										<form method='POST' enctype='multipart/form-data'>
											<fieldset>
											
												<div class="d-flex align-items-center mb-30">
													<div class="profile-image">
														<img src="<?php echo dashboard::call('user:avatar'); ?>" alt="image" class='img-thumbnail' id='profile-image'>
														<div class="update-image">
															<label for=""><i class="lni lni-cloud-upload"></i></label>
															<input type="file" accept='.jpg,.png,.gif,.jpeg' data-uss-image-preview='#profile-image' name='avatar'>
														</div>
													</div>
													<div class="profile-meta">
														<h5 class="text-bold text-dark mb-10 fw-400">
															<?php echo $username; ?>
														</h5>
														<p class="text-sm text-gray">
															<?php echo uss::$global['user']['usercode']; ?>
														</p>
													</div>
												</div>
												
												<div class="mb-4">
												
													<label class='form-label'>Email</label>
													<input type="email" placeholder="<?php echo uss::$global['user']['email']; ?>" class='form-control <?php if( $lockemail ) echo 'cursor-not-allowed'; ?>' value="<?php echo uss::$global['user']['email']; ?>" <?php echo !$lockemail ? "name='email'" : "disabled"; ?> required>
													
													<?php 
														if( uss::$global['usermeta']->get('v-code:update', uss::$global['user']['id']) ) {
															$new_email = uss::$global['usermeta']->get('v-code:email', uss::$global['user']['id']);
															echo "<div class='mt-2 text-center text-muted fs-12px'>
																Please click the link sent to <span class='text-warning'>{$new_email}</span> to update your email
															</div>";
														}
													?>
												</div>
												
												<input type='hidden' name='nonce' value='<?php echo uss::nonce( $nonce_key ); ?>'>
												<input type='hidden' name='form' value='profile'>
												
												<?php 
												
													/*
														Allow module to add some extra detail!
													*/
													
													events::exec('dashboard.account::profile-form'); 
													
												?>
												
												<div class='text-end'>
													<button class='btn btn-success w-100 btn-class-1' type='submit'>
														Update
													</button>
												</div>
											
											</fieldset>
										</form>
										
									</div>
								
								</div>
								
							</div>
						</div>
					<!-- end card -->
					</div>
					<!-- end col -->
					
					<?php 
					
						/*
							Another spot to add custom bootstrap row
						*/
						
						events::exec('dashboard.account-row::between'); 
						
					?>
					
					<div class="<?php echo dashboard::config('@class=dashboard.account:col-right') ?? 'col-lg-7'; ?>">
						<div class="card settings-card-2 mb-30">
							<div class='card-body'>
							
								<div class='p-3'>
								
									<div class="lead mb-4">Password</div>
									
									<form action="" method='POST'>
										<fieldset>
										
											<div class="row">
											
												<div class="col-12">
													<div class="mb-3">
														<input type="password" placeholder="Old Password" class='form-control' name='old_password' required>
													</div>
												</div>
												
												<div class="col-sm-6 mb-3">
													<div class="">
														<label class='form-label'>Password</label>
														<input type="password" placeholder="New Password" class='form-control' name='password' required>
													</div>
												</div>
												
												<div class="col-sm-6 mb-4">
													<div class="">
														<label class='form-label'>Retype Password</label>
														<input type="password" placeholder="Confirm Password" class='form-control' name='confirm_password' required>
													</div>
												</div>
												
												<input type='hidden' name='nonce' value='<?php echo uss::nonce( $nonce_key ); ?>'>
												<input type='hidden' name='form' value='password'>
												
												<div class="col-12">
													<button class="btn btn-secondary btn-hover w-100 btn-class-2">
														Change Password
													</button>
												</div>
												
											</div>
											
										</fieldset>
									</form>
									
								</div>
								
							</div>
						</div>
						<!-- end card -->
					</div>
					<!-- end col -->
					
					<?php 
					
						/*
							The final spot to add bootstrap row
						*/
						
						events::exec('dashboard.account-row::after'); 
						
					?>
					
				</div>
				<!-- end row -->
			</div>
			<!-- end container -->
		</section>
		
	<?php });
	
});