<?php 
	
	( defined( 'DASHBOARD_MOD_DIR' ) && uss::$global['user']['id'] ) OR DIE; 
	
	
	//! Get the UserCode!
	
	$code = uss::query(3);
	if( empty($code) ) $code = uss::$global['user']['usercode'];
	
	
	//! Get the user!
	
	$prefix = DB_TABLE_PREFIX;
	
	$user = dashboard::fetch_assoc( "{$prefix}_users", $code, "usercode" );
	
	
	//! Initialize the hierarchy class;
	
	$hierarchy = new hierarchy();
	
	
	/*
		Now check if the usercode belongs to a child of the current user
		Hence, prevent the user from viewing children that is not a member of the team!
	*/
	
	if( $user['id'] === uss::$global['user']['id'] ) $approved = true;
	else $approved = !!$hierarchy->descendants_of( uss::$global['user']['id'], "id = '{$user['id']}'" )->num_rows;
	
	
	/*
		Now! we create a function that will display the rectangular node
		Which will contain 'photo, name and other info'
	*/
	
	$value_of = function( $user, $info = '' ) {
		$avatar = dashboard::call('user:avatar', $user['id']);
		$title = $user['username'] ?: $user['email'];
		$value = "
			<div data-node='{$user['usercode']}''>
				<div class='depth'>{$info}</div>
				<div class='mb-1'>
					<img src='{$avatar}' class='img-fluid'>
				</div>
				<div class='text-truncate title'>{$title}</div>
			</div>
		";
		return $value;
	};
	
	
	/*
		If approval fails,
		Force user to view their own node!
	*/
	
	if( !$approved ) $user = uss::$global['user'];
	
	
	// Get the parent node;
	
	$parent = dashboard::fetch_assoc( "{$prefix}_users", $user['parent'] );
	
	
	// Now find all descendants of the user!
	
	$descendants = $hierarchy->descendants_of( $user['id'], "depth < 4" );
	
	
	// Prepare the Tree!
	
	$tree = array();
	
	if( $parent ) {
		$tree[] = array(
			"id" => $parent['id'], 
			"value" => $value_of( $parent, "<i class='mdi mdi-arrow-up-bold-circle root-icon'></i>" ), 
			"parent" => null
		);
	};
	
	$tree[] = array(
		"id" => $user['id'],
		"value" => $value_of( $user, "<i class='mdi mdi-sticker-check root-icon root'></i>" ),
		"parent" => $parent ? $parent['id'] : null
	);
	
	if( $descendants->num_rows ) {
		while( $child = $descendants->fetch_assoc() ) {
			$children = $hierarchy->descendants_of( $child['id'] )->num_rows;
			$tree[] = array(
				"id" => $child['id'],
				"value" => $value_of( $child, $children ? "<span class='children'>{$children}</span>" : null ),
				"parent" => $child['parent']
			);
		};
	};
	
	$jsonTree = addslashes(json_encode($tree));
	
?>
	
	<script>
		"use strict";
		let tree = JSON.parse(<?php echo "'{$jsonTree}'"; ?>);
		(new treeData).build(tree, function(result) {
			$('#hierarchy').get(0).appendChild(result);
			$(result).find('a').addClass('node').each(function() {
				let icon = $(this).find('.root-icon.root');
				if( icon.length ) {
					icon.removeClass('root');
					$(this).addClass('root');
				};
			});
			$('#hierarchy').click(function(e) {
				let el = e.target;
				while( el && !el.hasAttribute('data-node') ) el = el.parentElement;
				if( !el ) return;
				window.location.href = `<?php echo core::url( ROOT_DIR . "/" . $FOCUS ); ?>/${el.dataset.node}`;
			});
		});
	</script>

