<?php 

defined( "DASHBOARD_MOD_DIR" ) OR DIE;

// Autoload the database!

$prefix = DB_TABLE_PREFIX;

$queries = [];

/*
	Alright! Here we create a table to manage users
	- If the table does not exists
*/

$queries[] = "
	CREATE TABLE IF NOT EXISTS {$prefix}_users (
		id INT NOT NULL PRIMARY KEY AUTO_INCREMENT,
		email VARCHAR(255) NOT NULL UNIQUE,
		username VARCHAR(25) DEFAULT NULL UNIQUE,
		password VARCHAR(255) NOT NULL,
		register_time TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP(),
		usercode VARCHAR(12) NOT NULL UNIQUE,
		last_seen TIMESTAMP DEFAULT CURRENT_TIMESTAMP(),
		parent INT DEFAULT NULL,
		FOREIGN KEY(parent) REFERENCES {$prefix}_users(id) ON DELETE SET NULL
	)
";


/*
	And Here, We create a table to manage notifications
	- That again; is if the table doesn't already exists
*/

$queries[] = "
	CREATE TABLE IF NOT EXISTS {$prefix}_notifications (
		id INT NOT NULL PRIMARY KEY AUTO_INCREMENT,
		origin INT,
		model VARCHAR(100) DEFAULT NULL COMMENT 'TYPE: COMMENT, REPLY, mod-name',
		userid INT NOT NULL,
		period TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
		message VARCHAR(5000),
		viewed TINYINT NOT NULL DEFAULT 0,
		redirect VARCHAR(255) DEFAULT NULL COMMENT 'URL',
		image VARCHAR(255),
		hidden TINYINT NOT NULL DEFAULT 0,
		FOREIGN KEY(userid) REFERENCES {$prefix}_users(id) ON DELETE CASCADE
	)
";


# Now! Run all the queries;

foreach( $queries as $SQL ) {
	uss::$global['mysqli']->query( $SQL );
}

/*
	
	CREATE A USER META TABLE
	---------------------------
	
	- The usermeta table stores additional information about the user
	
	- The table is automatically created by the `pairs` class
	
	- We also need to link it to the ..._users table so the FOREIGN KEY can take effect!
	
*/

uss::$global['usermeta'] = new pairs( uss::$global['mysqli'], "{$prefix}_usermeta" );

uss::$global['usermeta']->linkParentTable( "{$prefix}_users" );

