<?php 

defined( 'DASHBOARD_MOD_DIR' ) OR DIE;

/*
	Dominate the URL that matches : `domain.com/dashboard...`
*/

if( uss::query(0) == DASHBOARD_FOCUS_URI ) {
	
	$user = uss::$global['user'];
	
	if( !$user ) dashboard::config( 'auth', false );
	
	else {
		
		$permit = roles::user( $user['id'] )::hasPermission( 'view-dashboard' );
		
		if( $permit ) dashboard::config( 'auth', $permit );
		
		else {
			
			uss::view(function() {
				require VIEW_DIR . "/error-403.php";
			});
			
		};
		
	};
	
	/*
		- Add first instance of dashboard readiness!
		
		Note: The event can be overridden by modules that need custom functionality
	*/
	
	events::addListener('dashboard::ready', function() {
		
		/*
			Create Authentication Pages!
			
			- Signup 
			- Reset
			
		*/
		
		uss::focus( DASHBOARD_FOCUS_URI . '/(?:signup|reset)', function() {
			dashboard::config('auth-page', uss::query(1));
			dashboard::view(function(){});
		});
		
		
		/*
			Create internal pages!
		*/
		
		require DASHBOARD_MOD_DIR . '/pages/index.php';
		require DASHBOARD_MOD_DIR . '/pages/account.php';
		require DASHBOARD_MOD_DIR . '/pages/affiliates.php';
		require DASHBOARD_MOD_DIR . '/pages/hierarchy.php';
	
	}, EVENT_FLOAT );

};