<?php

defined( 'ROOT_DIR' ) OR DIE;

/*

	Module Name: Dashboard
	
	Version: 1.0.0
	
	Author Name: Uchenna Ajah (Ucscode)
	
	Author URI: //ucscode.me
	
	Description:	The dashboard is a module developed by the author of user synthetics to create a cpanel that is accessible to only logged-in user.
					The module interface can be used an modified by other modules.
					
	Copyright (c) 2023
	
*/


define( "DASHBOARD_MOD_DIR", __DIR__ );
define( "DASHBOARD_FOCUS_URI", 'dashboard' );


if( DB_CONNECT ) {
	
	
	// include dashboard resources;
	
	require DASHBOARD_MOD_DIR . '/model/db.php';
	require DASHBOARD_MOD_DIR . '/model/class.php';
	require DASHBOARD_MOD_DIR . '/model/DOMTablet.php';
	require DASHBOARD_MOD_DIR . '/model/roles.php';
	require DASHBOARD_MOD_DIR . '/model/hierarchy.php';
	
	
	// include PHPMailer Library;
	
	require DASHBOARD_MOD_DIR . '/model/PHPMailer/src/PHPMailer.php';
	require DASHBOARD_MOD_DIR . '/model/PHPMailer/src/Exception.php';
	require DASHBOARD_MOD_DIR . '/model/PHPMailer/src/SMTP.php';
	
	
	// markdown: for notification - ( and anywhere else applicable );
	
	require_once DASHBOARD_MOD_DIR . '/model/Parsedown.php';
	
	
	// initialize dashboard;
	
	require DASHBOARD_MOD_DIR . '/init.php';
	
	
	// create the user-interface;
	
	require DASHBOARD_MOD_DIR . '/interface.php';
	
	
	// prepare a readiness event to make dashboard available to all modules;
	
	events::addListener('modules-loaded', function() {
		
		/*
			--- [{ usage }] ---
			
			events::addListener('dashboard::ready', function() {
				// Your dashboard code here;
			});
		*/
		
		events::exec( 'dashboard::ready' );
		
		
		/*
			After other modules are done with dashboard setup;
			The setup will be used for further configuration;
		*/
		
		require DASHBOARD_MOD_DIR . '/final.php';
		
		
		 // Do not add a listener to the `dashboard::[[view]]` event 
		 
		events::exec('dashboard::[[view]]', [], null, function($key, $file) {
			return ( $file === (new ReflectionClass('dashboard'))->getFilename() );
		});
		
	});

} else {
	
	uss::focus( DASHBOARD_FOCUS_URI, function() {
		uss::view(function() {
			echo "
				<div class='container-fluid'>
					<div class='text-center p-4 row'>
						<div class='col-lg-6 mx-auto'>
							<h4><u>DATABASE CONNECTION IS DISABLED</u></h4>
							<div class='py-4 border my-4 rounded-2'>
								USE DASHBOARD MODULE! 
								<div class='my-3'></div>
								DB_CONNECT MUST BE SET TO <span class='text-info'>TRUE</span>
							</div>
						</div>
					</div>
				</div>
			";
		});
	});
	
};