"use strict";

$(function() {
	
	/* ========= sidebar toggle ======== */
	
	function mobileMenu( action ) {
		let list = [ ".sidebar-nav-wrapper", ".main-wrapper", ".overlay" ];
		for( let x of list ) {
			let el = $(x);
			el[ action ]( 'active' );
		}
	}
	
	$('#menu-toggle').on("click", function() {
		// toggle menu;
		mobileMenu( 'toggleClass' );
	});
	
	$('.overlay').on("click", function() {
		// remove menu;
		mobileMenu( 'removeClass' );
	});
	
	window.addEventListener('resize', function() {
		if( document.body.clientWidth > 1200 ) {
			mobileMenu( 'removeClass' );
		}
	});
	
	// ============== collapsng menu =================
	
	//! omitted
	
	// =============== mark notification ==============
	
	function mark_notification( indexes, event ) {
		$.ajax({
			method: 'POST',
			url: uss._ajax + '/notification.php',
			data: { 
				nx: indexes,
				nonce: uss._nonce,
				action: event
			},
			success: function( response ) {
				
				let result = JSON.parse( response );
				if( !result.status ) return;
				
				let nx_count;
				
				for( let i of indexes ) {
					
					let nx = $(`[data-nx='${i}']`); // notification;
					
					if( nx.hasClass('unviewed') ) {
						nx.removeClass('unviewed');
						$('.notification-box [data-nx-count]').each(function() {
							nx_count = parseInt( this.innerText.trim() );
							if( isNaN(nx_count) ) nx_count = 0;
							else nx_count--;
							if( nx_count < 1 ) $(this).addClass('d-none');
							else $(this).text( nx_count );
						});
					};
					
					if( ['remove', 'removed'].includes(event) ) {
						nx.each(function() {
							if( nx_count ) $(this).parent().fadeOut();
							else {
								Notiflix.Loading.dots();
								window.location.reload();
							}
						});
					}
					
				} // endfor;
				
			}
		});
	}
	
	$('[data-parse="nx"]').click(function(e) {
		//e.preventDefault();
		let el = e.target;
		while( el && !el.hasAttribute('data-nx') ) el = el.parentElement;
		if( !el ) return;
		mark_notification( [el.dataset.nx], 'viewed' );
	});
	
	$("[data-nx-action='mark-all']").click(function() {
		let list = [];
		$("#notification-list [data-nx]").each(function() {
			list.push( this.dataset.nx );
		});
		mark_notification( list, 'viewed' );
	});
	
	$("#notification-list [data-nx-action]").click(function() {
		let nx = $(this).parents('.single-notification').find('[data-nx]').attr('data-nx');
		mark_notification( [nx], this.dataset.nxAction );
	});
	
	
	// ================ domtablet checkbox ==================
	
	$("[data-domtablet]").each(function() {
		
		let name = this.dataset.domtablet;
		let self = this;
		
		let check_th = `input[type='checkbox'][data-check-all='${name}']`;
		let check_td = `input[type='checkbox'][data-check='${name}']`;
		
		$(self).find( check_th ).click(function() {
			$(self).find(`${check_th}, ${check_td}`).prop('checked', this.checked);
		});
		
		$(self).find( check_td ).click(function() {
			let checked_all = $(self).find(`${check_td}:checked`).length === $(self).find(`${check_td}`).length;
			$(self).find( check_th ).prop( 'checked', checked_all );
		});
		
		// ================ bulk submission warning =================
		
		let bulk_form = `.dt-uss-bulk form#dt-${name}-bulk`;
		
		$(self).find( bulk_form ).on('submit', function(e) {
			let form = this;
			e.preventDefault();
			bootbox.confirm({
				message: "Are you sure you want to apply this action?",
				className: 'text-center',
				size: 'small',
				closeButton: false,
				centerVertical: true,
				callback: function(e) {
					if( !e ) return;
					if( !$(self).find(`${check_td}:checked`).length ) return bootbox.alert({
						message: "<i class='bi bi-exclamation-octagon me-1'></i> No table rows were selected",
						className: 'text-center',
						closeButton: false
					});
					form.submit();
				},
				buttons: {
					confirm: { label: 'Yes' },
					cancel: { label: 'No' }
				}
			});
		});
		
	});
	
	
	/* 
		==================== Auto click a different object ==================
		
		Let's assume you want to hide an element because it's interface looks ugly
		
		You can still click on the hidden element by passing `[data-uss-trigger-click]` attribute to the custom 
		element that you've create to replace the ugly element. 
		
		Example;
		
		<input style='display: none' id='hidden-input'>
		
		<div class='custom-beautiful-input' data-uss-trigger-click='#hidden-input' />
		
	*/
	
	$("[data-uss-trigger-click]").click(function() {
		$( this.dataset.ussTriggerClick ).trigger( 'click' );
	});
	
});
