<?php

require __DIR__ . '/init.php';

if( !isset($_POST['type']) ) exit;

// --------- [{ Listen to the authentication event }] -----------

events::addListener('dashboard.ajax::auth', function() {
	
	/*
		validate user input;
	*/
	
	foreach( $_POST as $key => $value ):
		
		// remove unnecessary white space
		
		$value = trim($value);
		
		// hash password;
		
		if( !in_array( $key, ['password', 'confirm_password'] ) ) {
			
			if( in_array( $key, ['username', 'email', 'login'] ) ) $value = strtolower($value);
			
			$value = uss::htmlentities( $value );
			
		};
		
		$_POST[$key] = $value;
	
	endforeach;
	
	
	
	//  handle request by authentication type;
	
	switch( $_POST['type'] ) {
		
		case 'signup':
		case 'register':
				require __DIR__ . '/signup.php';
			break;
			
		case 'login':
		case 'signin':
				require __DIR__ . '/signin.php';
			break;
			
		case 'reset':
				require __DIR__ . '/reset.php';
			break;
			
		case 'reset-approved':
				require __DIR__ . '/reset-password.php';
			break;
			
	};
	
}, EVENT_FLOAT );


// ------- [{ Execute all authentication events in ascending order of priority }] ---------

events::exec('dashboard.ajax::auth', array(), true);

