<?php 

$overtake = array(
	[ 'dashboard.signin-form::input', 'input-reconfirm' ],
	[ 'dashboard.signin-form::below', 'account-signup' ],
	[ 'dashboard.signin-form::below', 'account-reset' ]
);

/*
	- Overrider and remove some content in the login page
	
	- Those which are not necessarily needed by the admin
*/

foreach( $overtake as $ev ) {
	events::addListener( $ev[0], function(){}, $ev[1] );
};


/*
	- Add CSS file that will be used across the admin panel
	
	- This will redesign the dashboard interface
*/

events::addListener('@head::after', function() {
	$href = core::url( ADMIN_MOD_DIR . '/assets/css/style.css' );
	echo "\t<link rel='stylesheet' href='{$href}' />\n";
});


/*
	Now! create custom contents
	-----------------------------
	Technically, in the sign-in page!
*/

events::addListener('dashboard.signin-form::above', function() { ?>
	<h3 class='text-center fw-light mb-3'>
		<i class='mdi mdi-star-shooting animate__animated animate__delay-1s animate__flash '></i> <br> Hi Admin
	</h3>
<?php });


events::addListener('dashboard.signin-form::input', function() { ?>
	<div class="mb-3">
		<div class='input-group'>
			<span class='input-group-text'>
				<i class='lni lni-consulting'></i> 
			</span>
			<input type="email" placeholder="Email" class='form-control' name='login' required>
		</div>
	</div>
<?php }, 'input-login');


events::addListener('dashboard.signin-form::input', function() { ?>
	<div class="mb-4">
		<div class='input-group'>
			<span class='input-group-text'>
				<i class='lni lni-key'></i> 
			</span>
			<input type="password" placeholder="Password" class='form-control' name='password' required>
		</div>
	</div>
<?php }, 'input-password'); 


events::addListener('dashboard.signin-form::input', function() { ?>
	<div class="">
		<button class="btn btn-outline-success w-100" type='submit'>
			<i class='lni lni-power-switch'></i> - Login
		</button>
	</div>
<?php }, 'input-submit');


// ------------- [ left description ] -------------

events::addListener('auth::trademark', function() { ?>
	<h1 class="text-white mb-10">
		<?php echo uss::$global['title']; ?>
	</h1>
	<p class="text-light">
		Professional Platform for <br> Professional Developers &amp; Entreprenuers
	</p>
<?php }, 0); 