<?php 
	
	(defined( 'DASHBOARD_MOD_DIR' ) && isset($ticket)) OR DIE;
	
	$prefix = DB_TABLE_PREFIX;
	
	$SQL = "
	
		SELECT 
		
			{$prefix}_ticket_replies.*,
				{$prefix}_users.username,
					{$prefix}_parent.message as parent_message,
						{$prefix}_parent.selfie as parent_selfie
						
		FROM {$prefix}_ticket_replies
		
		INNER JOIN {$prefix}_users
			ON {$prefix}_ticket_replies.userid = {$prefix}_users.id
			
		LEFT JOIN {$prefix}_ticket_replies as {$prefix}_parent
			ON {$prefix}_parent.id = {$prefix}_ticket_replies.parent_id
			
		WHERE {$prefix}_ticket_replies.ticket_id = '{$ticket['id']}'
		
	";
	
	$result = uss::$global['mysqli']->query( $SQL );
	
	$table = new DOMTablet( 'support' );
	$table->data( $result );
	$table->columns(array('content' => ''));
	
	/* Hide the table head! */
	
	$table->table->getElementsByTagName('thead')->item(0)->setAttribute('class', 'd-none');
	
	$table->chunk(1000);
	
	/*
		- $table->chunk(1000) indicates that the table data will be divided on each 1000 rows
		
		- A navigation button will then appear in order to view the next set of data
		
		- I still wonder what level of problem will lead to 1000 conversation!
	*/
	
?>

<?php 
	
	//! Add a reply item to the dropdown!
	
	events::addListener('util.support-ticket:chat-dropdown', function($data) {
		if( $data['ticket']['status'] != 'open' ) return;
?>
	<li>
		<a class='dropdown-item' href='javascript:void(0)' data-action='reply'>
			<i class='lni lni-reply me-1'></i> Reply
		</a>
	</li>				
<?php }); ?>


<!--- [conversations] --->

<div class='border bg-light p-3 rounded-3 mb-3 chat-container'>

<?php
	
	if( !$result->num_rows ) {
		
		echo "<h1 class='display-6 text-center text-muted py-3'>
			No Conversation
		</h1>
		";
		
	} else {
		
		$table->prepare(function($data) use($ticket) {
			
			
			//! Get Chat Direction;
			
			if( uss::query(0) == DASHBOARD_FOCUS_URI && $data['viewpoint'] == 'client' ) $margin = 'ms-4 ms-sm-5 chat-right';
			else if( uss::query(0) == ADMIN_FOCUS_URI && $data['viewpoint'] == 'admin' ) $margin = 'ms-4 ms-sm-5 chat-right';
			else $margin = 'me-4 me-sm-5 chat-left';
			
			
			//! Identity;
			
			if( $data['viewpoint'] !== 'admin' ) {
				$icon = 'mdi mdi-account-circle-outline';
				if( uss::query(0) == DASHBOARD_FOCUS_URI ) $self = 'ME';
				else $self = $data['username'] ?? 'CLIENT';
			} else {
				$icon = 'mdi mdi-face-agent';
				$self = 'SUPPORT';
			};
			
			
			//! Detect Links
			
			$regex = core::regex('url');
			
			$data['message'] = preg_replace_callback($regex, function($match) use($regex) {
				if( preg_match($regex, preg_replace("/\.+/", ".", $match[0])) ) {
					$href = trim($match[0]);
					if( !preg_match("/^https?:\/\//", $href ) ) $href = "//{$href}";
					$anchor = "<a href='{$href}' class='link' target='_blank'>{$match[0]}</a>";
					return $anchor;
				};
				return $match[0];
			}, $data['message']);
			
			$data['message'] = nl2br($data['message']);
			
			
			//! Manage Timestamp;
			
			$epoch = core::elapse( $data['period'] );
			
			if( uss::query(0) == DASHBOARD_FOCUS_URI ) {
				
				if( $ticket['status'] == 'open' ) {
					$actionNode = "
						<div class='ms-1'>
							<a href='javascript:void(0)' class='action-node' title='reply' data-action='reply'>
								<i class='lni lni-reply'></i>
							</a>
						</div>
					";
				} else $actionNode = null;
				
			} else {
				
				$actionNode = "
					<div class='dropdown ms-1'>
						<a class='action-node px-1' href='#' role='button' data-bs-toggle='dropdown' aria-expanded='false'>
							<i class='lni lni-line-double'></i>
						</a>
						<ul class='dropdown-menu fs-12px'>
				";
				
					ob_start();
					
					//! Add addition dropdown item
					
					events::exec('util.support-ticket:chat-dropdown', array( 
						'ticket' => $ticket, 
						'data' => $data
					));
					
					$actionNode .= ob_get_clean();
				
				$actionNode .= "
							<li>
								<a class='dropdown-item' href='javascript:void(0)' data-action='delete'>
									<i class='lni lni-close me-1'></i> Delete
								</a>
							</li>
						</ul>
					</div>
				";
			
			};
			
			
			//! Display parent message;
			
			if( !empty($data['parent_message'] ) ) {
				$parentMsg = "
					<div class='parent-msg'>
						<a class='line-clamp' href='javascript:void(0)' data-seek='#_{$data['parent_selfie']}'>
							{$data['parent_message']}
						</a>
					</div>
				";
			} else $parentMsg = null;
			
			
			//! Delivery Message;
			
			$__key = base64_encode($data['id']);
			
			$data['content'] = "
				<div class='border p-3 rounded-2 my-1 {$margin} chat-box fs-13px animate__animated animate__fast' id='_{$data['selfie']}' data-key='{$__key}'>
					<div class='d-flex'>
						<div class='w-100 mb-1'>
							{$parentMsg}
							<div class='' data-msg>{$data['message']}</div>
						</div>
						{$actionNode}
					</div>
					<div class='d-flex justify-content-between align-items-center'>
						<div class='text-capitalize'><i class='{$icon} fs-22px'></i> <sup>{$self}</sup></div>
						<div class='fs-10px epoch'>{$epoch}</div>
					</div>
				</div>
			";
			
			
			//! Handle final output;
			
			events::exec('util.support-ticket:chat-block', array(
				'ticket' => &$ticket,
				'data' => &$data
			));
			
			return $data;
			
		}, true); 
		
		
		//! Add a Chat Refresh Button!
		
		if( $ticket['status'] == 'open' ) {
			echo "
				<div class='text-end'>
					<a onclick='window.location.reload()' class='btn btn-warning btn-sm' title='refresh'>
						<i class='bi bi-arrow-counterclockwise'></i>
					</a>
				</div>
			";
		};
		
	};
	
?>

</div>