<?php 

defined( 'DASHBOARD_MOD_DIR' ) OR DIE;


//! Create a support ticket {Child} Menu;

$ticket = uss::$global['menu']->get( $menu_title )->add('list', array(
	'label' => 'view tickets',
	'href' => core::url( ROOT_DIR . '/' . ( $FOCUS = $SUPPORT_PATH ) )
));

$ticket->set_attr( 'active', $_GET['query'] == $FOCUS );


/*
	
*/

uss::focus( $FOCUS, function() use($FOCUS) {
	
	//! Attach an event to handle Query;
	
	events::addListener('dashboard.support-ticket::QUERY', function( $data ) {
		
		$prefix = DB_TABLE_PREFIX;
		
		$data['userid'] = uss::$global['user']['id'];
		
		if( empty($data['SQL']) ) {
			
			$data['SQL'] = "
				
				SELECT 
					
					TICKETS.*,
					IFNULL(REPLIES.unseen, 0) AS unseen					
					
				FROM (
				
					SELECT 
					
						{$prefix}_tickets.*,
							IFNULL({$prefix}_users.username, {$prefix}_users.email) AS name,
								COUNT({$prefix}_ticket_replies.ticket_id) AS chats
							
					FROM {$prefix}_tickets
					
					INNER JOIN {$prefix}_users
						ON {$prefix}_tickets.userid = {$prefix}_users.id
						
					LEFT JOIN {$prefix}_ticket_replies
						ON {$prefix}_tickets.id = {$prefix}_ticket_replies.ticket_id
						
					WHERE {$prefix}_tickets.userid = '{$data['userid']}'
					
					GROUP BY {$prefix}_tickets.id
					
					ORDER BY {$prefix}_tickets.id DESC
				
				) AS TICKETS
				
				LEFT JOIN (
				
					SELECT 
					
						{$prefix}_ticket_replies.ticket_id,
							COUNT({$prefix}_ticket_replies.seen) AS unseen
							
					FROM {$prefix}_ticket_replies
					
					WHERE viewpoint = 'admin'
						AND seen = 0
						
					GROUP BY {$prefix}_ticket_replies.ticket_id
						
				) AS REPLIES
				
					ON TICKETS.id = REPLIES.ticket_id
				
			";
			
		};
		
		$result = uss::$global['mysqli']->query( $data['SQL'] );
		
		if( empty( $data['table']->data ) ) $data['table']->data( $result );
		
		if( empty($data['table']->columns) ) $data['table']->columns( $data['columns'] );
		
		$data['table']->wrap();
		
	});
	
	
	//! The event compontents
	
	$SQL = '';
	$table = new DOMTablet( 'support' );
	$columns = array('content' => '');
	
	
	//! The QUERY Event!
	
	events::exec( 'dashboard.support-ticket::QUERY', array( 
		'SQL' => &$SQL, 
		'table' => &$table,
		'columns' => &$columns
	) );
	
	
	//! Now display the dashboard!
	
	dashboard::view(function() use($table, $FOCUS) { 
		
		
		
	?>
		
		<div class='container-fluid'>
			<?php 
				$table->prepare(function($data) use($FOCUS) {
					
					ob_start();
					
					// return a "BOOTSTRAP" color based on supplied text;
					
					$color = dashboard::call('color', $data['status']);
					
					$href = core::url( ROOT_DIR . '/' . "{$FOCUS}/chat/{$data['uniqid']}" );
					
			?>
			
				<div class='d-flex ticket-row'>
				
					<div class='me-3'>
						<?php if( empty($data['unseen']) ): ?>
							<i class='bi bi-info-circle'></i>
						<?php else: ?>
							<i class='lni lni-alarm text-warning animate__animated animate__infinite animate__swing'></i>
						<?php endif; ?>
					</div>
					
					<div class='w-100'>
					
						<div class='fs-12px mb-1 pb-1'>
							Ticket ID: <a href='<?php echo $href; ?>'>
								<span class='fw-semibold text-danger'>
									<?php echo $data['uniqid']; ?>
								</span>
							</a>
						</div>
						
						<p class='fw-semibold'>
							<a href='<?php echo $href; ?>'>
								<?php echo $data['subject']; ?>
							</a>
						</p>
						
						<div class='fs-12px ticket-info'>
							<div class='ticket-data'><?php echo (new DateTime($data['period']))->format("Y M d"); ?></div>
							<div class='ticket-data'><i class='bi bi-chat'></i> <?php echo $data['chats']; ?></div>
							<div class='ticket-data text-uppercase text-<?php echo $color; ?>'><?php echo $data['status']; ?></div>
							<!-- replace:ticket-data -->
						</div>
						
					</div>
					
				</div>
				
			<?php 
					
					$data['content'] = ob_get_clean();
					
					/*
						Give Modules Permission TO...
						Do something with the data!
					*/
					
					events::exec( 'dashboard.support-ticket:data', array( 'data' => &$data ) );
					
					return $data;
					
				}, true); 
			?>
		</div>
		
<?php 	});
	
});

