<?php 

defined( 'ADMIN_MOD_DIR' ) OR DIE;


//! Create a support ticket {Child} Menu

$new = uss::$global['menu']->get( $menu_title )->add('new', array(
	'label' => 'New ticket',
	'href' => core::url( ROOT_DIR . "/" . ( $FOCUS = $SUPPORT_PATH . "/new" ) )
));

$new->set_attr( 'active', $_GET['query'] === $FOCUS );


//! Focus On The URL

uss::focus( $FOCUS, function() {
	
	//! Handle Post Request When It is submitted!
	
	require __DIR__ . '/POST/new.php';
	
	//! Display the dashboard interface!
	
	dashboard::view(function() { ?>
		
		<div class='container-fluid'>
			<div class='row'>
				
				<?php 
					events::addListener('dashboard.support-ticket:new', function() { 
				?>
					<div class='col-lg-9 mx-auto'>
						<h1 class='display-6 text-center mb-4 text-muted'>How Can We Help You?</h1>
					</div>
				<?php }, EVENT_FLOAT); ?>
				
				<?php 
					
					/*
						- The event below is what literally makes up the support ticket FORM!
						- I highly suggest you don't overwrite it!
						
						- To avoid conflict of overwriting the FORM, the event ID will be randomized!
					*/
					
					$eventID = "0-" . core::keygen(30);
					
					events::addListener('dashboard.support-ticket:new', function() {
						
						// Think in the `XPath` Manner! ;-)
						
						$card_class = dashboard::config('@class=support-ticket-new:col-x') ?? 'col-lg-9 mx-auto';
				?>
				
				<div class='<?php echo $card_class; ?>'>
					
					<div class='card'>
						<div class='card-body'>
							
							<div class='p-3 p-sm-4'>
							
								<form method='POST'>
									
									<?php 
										events::addListener('dashboard.support-ticket-form::input', function() { 
									?>
									<div class='mb-4'>
										<label class='form-label --required'>Subject</label>
										<input type='text' name='subject' placeholder='' class='form-control' value='<?php echo dashboard::config('_POST.subject'); ?>' required>
									</div>
									<?php }, 'input-A'); ?>
									
									<?php 
										events::addListener('dashboard.support-ticket-form::input', function() { 
									?>
									<div class='mb-4'>
										<label class='form-label --required'>Description</label>
										<textarea rows='9' type='text' name='description' placeholder='Please describe your issue' class='form-control fs-12px' data-uss-editor='bubble' required><?php echo dashboard::config('_POST.description'); ?></textarea>
									</div>
									<?php }, 'input-B'); ?>
									
									<?php 
										events::addListener('dashboard.support-ticket-form::input', function() { 
									?>
									<div class='mb-4'>
										<button type='submit' class='btn btn-success w-100'>
											Create Ticket
										</button>
									</div>
									<?php }, 'input-C'); ?>
								
									<input type='hidden' name='nonce' value='<?php echo uss::nonce('helpdesk'); ?>'>
									
									<?php events::exec('dashboard.support-ticket-form::input'); ?>
									
								</form>
								
							</div>
							
						</div>
					</div>
					
				</div>
				
				<?php }, $eventID); ?>
					
				<?php events::exec( 'dashboard.support-ticket:new' ); ?>
					
			</div>
		</div>
		
<?php	});
	
});


