<?php 

defined( 'ADMIN_MOD_DIR' ) OR DIE;


// ADMIN PANEL CHAT!

uss::focus( $FOCUS . "/\w+", function() {
	
	/*
		utils/lang - manages the css and javascript 
		Must be implemented for a responsive page
	*/
	
	require realpath( __DIR__ . '/../' ) . '/utils/lang.php';
	
	
	//! BEGIN!
	
	$uniqid = uss::htmlentities( uss::query(2) ); // Get the ticket ID;
	
	$prefix = DB_TABLE_PREFIX;
	
	
	/*
		Find the ticket!
	*/
	
	$TICKET_SQL = "
		
		SELECT 
		
			{$prefix}_tickets.*,
				{$prefix}_users.username,
					{$prefix}_users.email,
						{$prefix}_users.usercode
					
		FROM {$prefix}_tickets
		
		LEFT JOIN {$prefix}_users
			ON {$prefix}_tickets.userid = {$prefix}_users.id
			
		WHERE {$prefix}_tickets.uniqid = '{$uniqid}'
		
	";
	
	$ticket = uss::$global['mysqli']->query( $TICKET_SQL )->fetch_assoc();
	
	//! END
	
	
	// Mark Seen!
	
	if( $ticket ) {
		
		$SQL = sQuery::update( "{$prefix}_ticket_replies", array( 'seen' => 1 ), "
			ticket_id = '{$ticket['id']}'
			AND viewpoint = 'client'
		");
		
		uss::$global['mysqli']->query( $SQL );
		
	};
	
	
	/*
		Handle Post Request!
	*/
	
	require realpath( __DIR__ . '/../' ) . '/utils/chat-POST.php';
	
	
	dashboard::view(function() use($ticket) {
		
		//! Return an empty state error if no ticket was found!
		
		if( !$ticket ) {
			dashboard::call('empty:no-result', function() {
				echo "
					<p class='mb-3'>No matching support ticket was found</p>
					<a href='./' class='btn btn-info'>
						<i class='mdi mdi-ticket'></i> Tickets
					</a>
				";
			});
			return;
		};
		
	?>
		
	<div class='container-fluid'>
		<div class='row'>
		
			<div class='col-lg-5 col-md-10 mx-auto mb-3'>
			
				<?php 
					events::addListener('admin.support-ticket-chat:col-left', function() use($ticket) {
				?>
				
				<div class='card ticket-sticker'>
					<div class='card-body'>
					
						<div class='d-flex justify-content-between text-sm mb-3 border-bottom pb-2'>
							<div class='me-4 text-primary'><?php echo $ticket['uniqid']; ?></div>
							<div class='text-end'>
								<span class='badge bg-<?php echo dashboard::call('color', $ticket['status']); ?> text-uppercase fs-12px'>
									<?php echo $ticket['status']; ?>
								</span>
							</div>
						</div>
						
						<div class='row mb-2 align-items-baseline'>
							<div class='col-3 col-sm-2'>
								<img src='<?php echo dashboard::call('user:avatar', $ticket['userid']); ?>' width='40px' class='img-fluid'>
							</div>
							<div class='col-9 col-sm-10'>
								<div class='mb-1 text-muted border-bottom pb-1 mb-2 text-truncate'>
									<a href='<?php echo core::url( ROOT_DIR . "/" . ADMIN_FOCUS_URI . "/users/{$ticket['usercode']}" ); ?>'>
										<small><u><?php echo $ticket['username'] ?? $ticket['email']; ?></u></small>
									</a>
								</div>
								<p class='fs-18px'><?php echo $ticket['subject']; ?></p>
							</div>
						</div>
						
						<div class='bg-light p-3 border mb-1 ticket-issue'>
							<?php echo $ticket['description']; ?>
						</div>
						
						<div class='text-end text-muted'>
							<small><?php echo $ticket['period']; ?></small>
						</div>
						
						<hr>
						
						<?php if( $ticket['status'] == 'cancelled' ): ?>
							<div class='text-center fs-12px mb-2 text-danger'>
								<i class='mdi mdi-alert-outline me-1'></i>The ticket was cancelled by the user
							</div>
						<?php endif; ?>
						
						<form method='POST'>
							<input type='hidden' name='nonce' value='<?php echo uss::nonce('chat'); ?>'>
							<input type='hidden' name='type' value='state'>
							<div class='mb-2'>
								<select class='form-control form-select' name='status' value='<?php echo $ticket['status']; ?>' required>
									<option value='open'>Open</option>
									<option value='resolved'>Resolved</option>
									<option value='closed'>Closed</option>
									<?php if( $ticket['status'] == 'cancelled' ): ?>
										<option value='cancelled'>Cancelled</option>
									<?php endif; ?>
								</select>
							</div>
							<div class=''>
								<button class='btn btn-info w-100 fs-14px'>
									Update Ticket
								</button>
							</div>
						</form>
						
					</div>
				</div>
				
				<?php }); ?>
					
				<?php events::exec('admin.support-ticket-chat:col-left'); ?>
				
			</div>
			
			<div class='col-lg-7 col-md-10 mx-auto'>
			
				<?php 
					
					events::addListener('admin.support-ticket-chat:col-right', function() use($ticket) {
						// get the chat boxes from "utils" directory
						require realpath( __DIR__ . '/../' ) . '/utils/chat-board.php'; 
					});
					
					events::addListener('admin.support-ticket-chat:col-right', function() use($ticket) {
						// get the textarea from "utils" directory
						require realpath( __DIR__ . '/../' ) . '/utils/textarea.php'; 
					});
					
					events::exec('admin.support-ticket-chat:col-right');
					
				?>
				
			</div>
			
		</div>
	</div>

<?php });
	
});