<?php 

defined( 'ADMIN_MOD_DIR' ) OR DIE;

if( $_SERVER['REQUEST_METHOD'] === 'POST' ) {
	
	if( isset($_POST['bulk_table']) ) {
		
		if( $_POST['bulk_nonce'] !== uss::nonce( "domtablet-tickets" ) ) {
			
			uss::console( ':alert', "<i class='mdi mdi-shield-off me-1'></i> Security Check Failed" );
			
		} else {
			
			$prefix = DB_TABLE_PREFIX;
			
			switch( $_POST['bulk_action'] ) {
				
				case 'delete':
						
						$values = implode(", ", array_map(function($value) {
							return uss::$global['mysqli']->real_escape_string( $value );
						}, $_POST['bulk_values']));
						
						$SQL = "
							DELETE FROM {$prefix}_tickets
							WHERE id IN({$values});
						";
						
						$status = uss::$global['mysqli']->query( $SQL );
						
						$message = $status ? "Ticket successfully deleted" : "Ticket(s) could not be deleted";
						
						uss::console( ':alert', $message );
						
						dashboard::call('form:prevent-resubmit');
						
					break;
					
				default:
				
					events::exec('admin.support-ticket::POST');
				
			};
			
		};
		
	};
	
};