<?php 
	
	defined( 'ADMIN_MOD_DIR' ) OR DIE;
	
	events::addListener('admin.settings::index', function( $data ) {
	
?>
	
	<div class='col-sm-6 col-md-4 text-center'>
		<a href='<?php echo $data['href'] . '/general'; ?>'>
			<div class='card rounded-1'>
				<div class='card-body display-6'>
					<h1 class='mb-2'> <span class='mdi mdi-wrench me-1'></span> </h1>
					<h3 class='fw-normal mb-2'>
						General
					</h3>
					<p class='text-sm text-capitalize'>Logo, site Name &hellip;</p>
				</div>
			</div>
		</a>
	</div>

<?php }, 'general');


uss::focus( ADMIN_FOCUS_URI . "/settings/general", function() {
	
	require __DIR__ . '/POST/settings-general.php';
	
	dashboard::view(function() {
		
?>
				
		<div class='container-fluid'>
				
			<div class='row'>
				
				<div class='col-lg-12 col-sm-10 m-auto border-bottom mb-4'>
					<h2 class='mb-3'>
						General Settings
					</h2>
				</div>
				
				<div class='col-lg-8 col-sm-10 m-auto'>
					
					<?php 
						events::exec( 'admin.settings.general-form::above' ); 
					?>
					
					<form method='POST' enctype='multipart/form-data'>
						<fieldset>
						
							<div class='mb-4 mb-md-5'>
								<div class='d-inline-flex'>
									<div class='text-center'>
										<div class='user-avatar site-icon mb-2'>
											<img src='<?php echo uss::$global['icon']; ?>' class='img-fluid the-image'>
										</div>
										<button class='btn btn-outline-success btn-sm' type='button' data-uss-trigger-click='#iconic'>Change Icon</button>
									</div>
								</div>
								<input type='file' name='icon' class='form-control d-none'  accept='.jpg,.jpeg,.png,.gif' id='iconic' data-uss-image-preview='.the-image'>
							</div>
						
							<div class='mb-4 mb-lg-5 row'>
								<label class='form-label col-lg-3'>Site Name</label>
								<div class='col-lg-9'>
									<input type='text' name='site[title]' class='form-control' value='<?php echo uss::$global['title']; ?>'>
								</div>
							</div>
						
							<div class='mb-4 mb-lg-5 row'>
								<label class='form-label col-lg-3'>Headline</label>
								<div class='col-lg-9'>
									<input type='text' name='site[tagline]' class='form-control' value='<?php echo uss::$global['tagline']; ?>'>
								</div>
							</div>
						
							<div class='mb-4 mb-lg-5 row'>
								<label class='form-label col-lg-3'>Description</label>
								<div class='col-lg-9'>
									<textarea type='text' name='site[description]' class='form-control' rows='8'><?php echo uss::$global['description']; ?></textarea>
								</div>
							</div>
							
							<?php 
								events::exec( 'admin.settings.general-form::input' ); 
							?>
							
							<div class='border-bottom mb-4'></div>
							
							<input type='hidden' name='nonce' value='<?php echo uss::nonce( 'general' ); ?>'>
							
							<div class=''>
								<button class='btn btn-primary'>
									<i class='mdi mdi-check me-1'></i> Save Changes
								</button>
							</div>
						
						</fieldset>
					</form>
					
					<?php 
						events::exec( 'admin.settings.general-form::below' ); 
					?>
					
				</div>
				
				<div class='col-lg-4 col-sm-10 m-auto'>
					<?php events::exec( 'admin.settings.general:col-right' ); ?>
				</div>
				
			</div>
			
		</div>

	<?php });
	
});
