<?php 
	
	defined( "ADMIN_MOD_DIR" ) or die;
	
	events::addListener('admin.settings::index', function( $data ) {

?>
		
	<div class='col-sm-6 col-md-4 text-center'>
		<a href='<?php echo $data['href'] . '/email'; ?>'>
			<div class='card rounded-1'>
				<div class='card-body display-6'>
					<h1 class='mb-2'> <span class='mdi mdi-email-multiple me-1'></span> </h1>
					<h3 class='fw-normal mb-2'>
						Email
					</h3>
					<p class='text-sm text-capitalize'>SMTP, Business Mail &hellip;</p>
				</div>
			</div>
		</a>
	</div>

<?php }, 'mailer');


uss::focus( ADMIN_FOCUS_URI . "/settings/email", function() {
	
	require __DIR__ . '/POST/settings-email.php';
	
	dashboard::view(function() {
		
?>

	<div class='container'>
		<div class='row'>
			
			<div class='col-lg-12 border-bottom mb-4'>
				<h2 class='mb-3'>Email Settings</h2>
			</div>
			
			<div class='col-lg-8'>
			
				<form method='post' enctype='multipart/form-data'>
					
					<div class='row mb-4 mb-sm-5'>
						<label class='col-lg-3 form-label --required'>Admin Email</label>
						<div class='col-lg-9'>
							<input type='email' name='email[admin]' class='form-control' placeholder='example &nbsp; &mdash; &nbsp; admin@domain.com' value='<?php echo uss::$global['options']->get('email:admin'); ?>' required>
							<p class='text-sm text-muted mt-1'>Merely a contact email</p>
						</div>
					</div>
					
					<div class='row mb-4 mb-sm-5'>
						<label class='col-lg-3 form-label'>From</label>
						<div class='col-lg-9'>
							<input type='email' name='email[from]' class='form-control' placeholder='example &nbsp; &mdash; &nbsp; no-reply@domain.com' value='<?php echo uss::$global['options']->get('email:from'); ?>'>
							<p class='text-sm text-muted mt-1'>Will be used over admin email if specified</p>
						</div>
					</div>
					
					<div class='row mb-4 mb-sm-5'>
						<label class='col-lg-3 form-label'>SMTP Option</label>
						<div class='col-lg-9 text-capitalize'>
							
							<div class='choice mb-4'>
								<?php
									foreach( ['default', 'custom'] as $value ):
										$checked = (uss::$global['options']->get('smtp:state') == $value) ? "checked" : "";
								?>
								<div class='form-check'>
									<input class='form-check-input' type='radio' name='smtp[state]' id='smtp-<?php echo $value; ?>' value='<?php echo $value; ?>' required <?php echo $checked; ?>>
									<label class='form-check-label' for='smtp-<?php echo $value; ?>'>Use default <?php echo $value; ?> settings</label>
								</div>
								<?php endforeach; ?>
							</div>
							
							<div class='smtp-settings'>
								<fieldset class='border-top pt-4' disabled>
								
									<div class='mb-3'>
										<label class='fw-light mb-1'>SMTP Server</label>
										<input type='text' class='form-control' name='smtp[server]' placeholder='example &nbsp; &mdash; &nbsp; smtp.gmail.com' value='<?php echo uss::$global['options']->get('smtp:server'); ?>' required>
									</div>
								
									<div class='mb-4'>
										<label class='fw-light mb-1'>SMTP Username</label>
										<input type='email' class='form-control' name='smtp[username]' placeholder='example &nbsp; &mdash; &nbsp; user@domain.com' value='<?php echo uss::$global['options']->get('smtp:username'); ?>' required>
									</div>
								
									<div class='mb-4'>
										<label class='fw-light mb-1'>SMTP Password</label>
										<input type='text' class='form-control' name='smtp[password]' placeholder='****' value='<?php echo uss::$global['options']->get('smtp:password'); ?>' required>
									</div>
								
									<div class='mb-4'>
										<label class='fw-light mb-1'>SMTP Port</label>
										<input type='text' class='form-control' name='smtp[port]' placeholder='example &nbsp; &mdash; &nbsp; 25' value='<?php echo uss::$global['options']->get('smtp:port'); ?>' required>
									</div>
								
									<div class='mb-4'>
										<label class='fw-light mb-1'>SMTP Security</label>
										<select type='text' class='form-control form-select' name='smtp[secure]' value='<?php echo uss::$global['options']->get('smtp:secure'); ?>' required>
											<option value='tls'>TLS</option>
											<option value='ssl'>SSL</option>
										</select>
									</div>
									
								</fieldset>
							</div>
							
						</div>
					</div>
					
					<?php 
						events::exec( 'admin.settings.email-form::input' ); 
					?>
					
					<div class='border-top mb-4'></div>
					
					<input type='hidden' name='nonce' value='<?php echo uss::nonce( 'email' ); ?>'>
					
					<div class=''>
						<button class='btn btn-primary'>
							<i class='mdi mdi-check'></i> Save Changes
						</button>
					</div>
					
				</form>
				
			</div>
			
			<div class='col-lg-4'>
				<?php 
					events::exec( 'admin.settings.email:col-right' ); 
				?>
			</div>
			
		</div>
	</div>

	<script>
		window.addEventListener('load', function() {
			let state = $("[name='smtp[state]']");
			state.on('change', function() {
				$('.smtp-settings fieldset').prop( 'disabled', this.value != 'custom' );
			});
			$('.smtp-settings fieldset').prop( 'disabled', $("[name='smtp[state]']:checked").val() != 'custom' );
		});
	</script>
	
<?php });
	
});
