<?php 

defined( 'ADMIN_MOD_DIR' ) OR DIE;

if( $_SERVER['REQUEST_METHOD'] == 'POST' ) {
	
	if( $_POST['nonce'] !== uss::nonce( 'email' ) ) 
		
		uss::console( ':alert', "Security Check Failed!" );
	
	else {
		
		
		// ------ [{ Create Email Event }] -------
		
		events::addListener( 'admin.settings.email::post', function() {
				
			$progress = [];
			
			foreach( ['email', 'smtp'] as $key ) {
				foreach( $_POST[$key] as $name => $value ) {
					$progress[] = uss::$global['options']->set( "{$key}:{$name}", $value );
				};
			};
			
			uss::$global['status'] = $status = !in_array(false, $progress);
			
			if( $status ) {
				uss::$global['message'] = "<i class='bi bi-check-circle text-success me-1'></i> Changes were saved";
			} else {
				uss::$global['message'] = "<i class='bi bi-x text-danger me-1'></i> Changes were not saved";
			};
			
			uss::console( ':alert', uss::$global['message'] );
			
		}, EVENT_FLOAT ); // [{ End Email Event }] 
		
		
		// ------- [{ Run Events }] ---------
		
		events::exec( 'admin.settings.email::post' );
		
		
	};
	
}