<?php 

uss::$global['menu']->get('users')->add('list', array(
	'label' => 'All users',
	'href' => core::url( ROOT_DIR . '/' . ADMIN_FOCUS_URI . '/users' )
));


uss::focus( ADMIN_FOCUS_URI . '/users', function() {
	
	
	require ADMIN_MOD_DIR . '/pages/POST/user-list.php';
	
	
	// --- [{ Get MYSQLI Result }] ---
	
	$prefix = DB_TABLE_PREFIX;
	
	$SQL = sQuery::select( "{$prefix}_users", "1 ORDER BY id DESC");
	
	
	// ---- [{ Create Event }] -------
	
	events::addListener('admin/users/list::search', function($data) use($prefix) {
		
		if( empty($_GET['search']) ) return;
		
		$search = uss::$global['mysqli']->real_escape_string( $_GET['search'] );
		
		$uss_users = $prefix . '_users';
		
		$data['SQL'] = "
			SELECT {$uss_users}.*
			FROM {$uss_users}
			LEFT JOIN (
				SELECT * FROM {$prefix}_usermeta
				WHERE _key = 'roles'
			) as usermeta_alt
			ON {$uss_users}.id = usermeta_alt._ref
			WHERE
				{$uss_users}.email LIKE '%{$search}%' 
				OR {$uss_users}.username LIKE '%{$search}%'
				OR {$uss_users}.usercode LIKE '%{$search}%'
				OR usermeta_alt._value LIKE '%{$search}%'
			ORDER BY {$uss_users}.id DESC
		";
		
	}, EVENT_FLOAT );
	
	
	// ----- [{ Exec Events }] -----
	
	events::exec( 'admin/users/list::search', array( 'SQL' => &$SQL ) );
	
	
	// ------ [{ Proceed }] -------
	
	$result = uss::$global['mysqli']->query( $SQL );
	
	
	// --- [{ Get DOMTablet Object }] ---
	
	$table = new DOMTablet( 'users' );
	
	$table->data( $result );
	
	$columns = array(
		'email',
		'confirmed',
		'role' => "role",
		'usercode' => 'code',
		'action' => ''
	);
	
	if( !empty(uss::$global['options']->get('user:collect-username')) ) {
		array_unshift($columns, 'username');
	};
	
	$table->columns($columns);
	
	$table->wrap();
	
	$table->widget('search', true);
	
	$table->widget('bulk', array(
		'delete' => 'delete'
	), 'id');
	
	
	// -------- [{ Allow Module Change }] -----
	
	events::exec('admin/users/list::table', array(
		'table' => &$table,
		'data' => null
	));
	
	dashboard::view(function() use($table) { 
		
	?>
		
		<?php 
			events::addListener('admin/users/list::dropdown', function($data) { 
			
				$href = core::url( ROOT_DIR . '/' . ADMIN_FOCUS_URI . "/users/{$data['usercode']}" );
		?>
			<li>
				<a class='dropdown-item' href='<?php echo $href; ?>'>
					<i class='lni lni-user me-1'></i> Edit
				</a>
			</li>
			<li>
				<button class='dropdown-item' name='action' value='delete'>
					<i class='lni lni-close me-1'></i> Delete
				</button>
			</li>
		<?php }); ?>
		
		<div class='container-fluid'>
			<div class='row'>
				<div class='col-lg-12'>
					
					<?php 
						echo $table->prepare(function($data) {
								
							$confirmed = !uss::$global['usermeta']->get('v-code', $data['id']);
							
							$icon = !$confirmed ? 'mdi mdi-alert-remove-outline text-danger' : call_user_func(function() use($data) {
								if( uss::$global['user']['id'] !== $data['id'] ) {
									return 'mdi mdi-checkbox-marked-circle-outline text-primary';
								} else return 'mdi mdi-account-reactivate text-success';
							});
							
							$data['confirmed'] = "<i class='{$icon} fs-1_5rem'></i>";
							
							$data['role'] = call_user_func(function($userid) {
								dashboard::call('user:assign-role', $userid);
								$roles = dashboard::call('user:roles', $userid);
								$value = dashboard::call('user:max-role', $userid);
								if( empty($value) ) return '<i class="fas fa-question-circle"></i>';
								if( in_array( 'blocked', $roles ) ) {
									$color = 'bg-warning';
									$prepend = "<span class='text-danger'>!</span>";
								} else {
									$color = 'bg-secondary';
									$prepend = null;
								};
								$badge = "{$prepend} <span class='badge {$color} bg-opacity-50 rounded-3 fw-normal'>{$value}</span>";
								return $badge;
							}, $data['id']);
							
							$data['action'] = "
								<form method='POST' data-uss-confirm='You are about making changes to the user data'>
									<input type='hidden' name='userid' value='{$data['id']}'>
									<div class='dropstart'>
										<a href='javascript:void(0)' class='inline-block p-2' type='button' data-bs-toggle='dropdown' aria-expanded='false'>
											<i class='lni lni-flickr'></i>
										</a>
										<ul class='dropdown-menu text-sm'>
							";
								
								// buffer output
								ob_start();
								events::exec( 'admin/users/list::dropdown', $data, true );
								$data['action'] .= ob_get_clean(); // save buffer
								
							"			</ul>
									</div>
								<form>
							";
							
							
							// ----- [{ Allow Module Change }] -------
							
							events::exec('admin/users/list::table', array(
								'table' => null,
								'data' => &$data
							));
							
							if( array_key_exists('username', $data) ) {
								$data['username'] = trim($data['username']);
								if( empty($data['username']) )
									$data['username'] = "<i class='fas fa-exclamation-circle text-muted'></i>";
							};
							
							return $data;
							
						}); 
					?>

				</div>
			</div>
		</div>
		
	<?php });
	
});