<?php 

defined( 'ADMIN_MOD_DIR' ) OR DIE;


$prefix = DB_TABLE_PREFIX;


$queries = array();


$queries[] = "
	CREATE TABLE IF NOT EXISTS {$prefix}_tickets (
		id INT NOT NULL PRIMARY KEY AUTO_INCREMENT,
		uniqid VARCHAR(10) NOT NULL UNIQUE,
		userid INT NOT NULL,
		FOREIGN KEY (userid) REFERENCES {$prefix}_users(id) ON DELETE CASCADE,
		period TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
		status VARCHAR(20) NOT NULL DEFAULT 'open',
		subject VARCHAR(255) NOT NULL,
		description TEXT
	);
";


$queries[] = "
	CREATE TABLE IF NOT EXISTS {$prefix}_ticket_replies (
		id INT NOT NULL PRIMARY KEY AUTO_INCREMENT,
		ticket_id INT NOT NULL,
		FOREIGN KEY (ticket_id) REFERENCES {$prefix}_tickets(id) ON DELETE CASCADE,
		message TEXT,
		period TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
		userid INT DEFAULT NULL,
		seen TINYINT NOT NULL DEFAULT 0,
		viewpoint VARCHAR(10) not null default 'client',
		parent_id INT,
		FOREIGN KEY (parent_id) REFERENCES {$prefix}_ticket_replies(id) ON DELETE SET NULL,
		selfie VARCHAR(10) NOT NULL UNIQUE
	);
";

foreach( $queries as $SQL ) {
	/*
		SQL - Query!
	*/
	uss::$global['mysqli']->query( $SQL );
};


