<?php 

// Focus on the admin Path;

define( 'ADMIN_MOD_DIR', __DIR__ );
define( 'ADMIN_FOCUS_URI', 'admin' );


/*
	- Guide user throught installation of dashboard!
	
	- Because Admin Panel will never run if dashboard module is absent!
	
*/

require_once ADMIN_MOD_DIR . "/views/help.php";


/*
	Now Let's Create the admin panel!
*/

events::addListener('dashboard::ready', function($focus) {
	
	/* 
		Global Resource:
	*/
	
	require_once ADMIN_MOD_DIR . '/model/db.php';
	require_once ADMIN_MOD_DIR . '/model/global.php';
	
	// 
	
	switch( uss::query(0) ):
	
		case ADMIN_FOCUS_URI:
		
			/*
				Configure Focus For Different Pages:
			*/
			
			dashboard::config( 'page:notification', ADMIN_FOCUS_URI . '/notifications' );
			dashboard::config( 'page:signout', ADMIN_FOCUS_URI . '/signout' );
			dashboard::config( 'signout-redirect-url', core::url( ROOT_DIR . '/' . ADMIN_FOCUS_URI ) );
			
			
			/*
				Redesign Admin Template:
			*/
			
			require ADMIN_MOD_DIR . '/redesign.php';
			
			
			// Init
			
			require ADMIN_MOD_DIR . '/init.php';
			
			
			// -- Trademark --;
			
			require ADMIN_MOD_DIR . '/views/footer.php';
			
			
			// Require Pages!
			
			require ADMIN_MOD_DIR . '/pages/index.php';
			require ADMIN_MOD_DIR . '/pages/users/index.php';
			require ADMIN_MOD_DIR . '/pages/support/index.php';
			require ADMIN_MOD_DIR . '/pages/tools.php';
			require ADMIN_MOD_DIR . '/pages/settings/index.php';
		
		break;
		
		case DASHBOARD_FOCUS_URI:
			
			// Support Ticket!
			
			require ADMIN_MOD_DIR . '/pages/support/index.php';
		
		break;
		
	endswitch;
	
	
	// Allow modules that wishes to load after the admin module;
	
	events::exec('admin::ready');
	
});


