<?php 

$prefix = DB_TABLE_PREFIX;

$tableset = array();

$tableset[] = "
	CREATE TABLE IF NOT EXISTS {$prefix}_exams (
		id int not null primary key auto_increment,
		userid int not null,
		created timestamp not null default CURRENT_TIMESTAMP(),
		name varchar(100),
		instruction text,
		exam_time float,
		department_id tinyint not null,
		`status` tinyint not null default 0,
		portal varchar(20) not null unique,
		start_date varchar(20) not null,
		FOREIGN KEY(userid) REFERENCES {$prefix}_users(id) ON DELETE CASCADE
	);
";

$tableset[] = "
	CREATE TABLE IF NOT EXISTS {$prefix}_portals (
		id int not null primary key auto_increment,
		userid int not null,
		portal_id varchar(20) not null,
		period timestamp default CURRENT_TIMESTAMP,
		complete tinyint not null default 0,
		FOREIGN KEY(portal_id) REFERENCES {$prefix}_exams(portal) ON DELETE CASCADE
	);
";

$tableset[] = "
	CREATE TABLE IF NOT EXISTS {$prefix}_subjects (
		id int not null primary key auto_increment,
		name varchar(255) not null unique
	);
";

$tableset[] = "
	CREATE TABLE IF NOT EXISTS {$prefix}_departments (
		id int not null primary key auto_increment,
		name varchar(255) not null unique
	);
";

$tableset[] = "
	CREATE TABLE IF NOT EXISTS {$prefix}_questions (
		id int not null primary key auto_increment,
		question text,
		image varchar(100),
		points float not null default 1,
		subject_id int not null,
		exam_id int not null,
		period timestamp not null default CURRENT_TIMESTAMP,
		option1 text,
		option2 text,
		option3 text,
		option4 text,
		correct tinyint not null default 1,
		FOREIGN KEY(exam_id) REFERENCES {$prefix}_exams(id) ON DELETE CASCADE
	);
";

$tableset[] = "
	CREATE TABLE IF NOT EXISTS {$prefix}_solutions (
		id int not null primary key auto_increment,
		student_id int not null,
		portal_id int not null,
		question_id int,
		answer tinyint not null default 0,
		period timestamp not null default CURRENT_TIMESTAMP,
		epoch varchar(10) not null default '0.0',
		FOREIGN KEY(portal_id) REFERENCES {$prefix}_portals(id) ON DELETE CASCADE,
		FOREIGN KEY(question_id) REFERENCES {$prefix}_questions(id) ON DELETE SET NULL
	);
";

$tableset[] = "
	CREATE TABLE IF NOT EXISTS {$prefix}_grades (
		id int not null primary key auto_increment,
		_from tinyint not null unique,
		_to tinyint not null unique,
		_name varchar(100) not null unique,
		_type varchar(3) not null unique
	);
";

// --- [{ Progress }] ---

$progress = array();
$error_list = array();

foreach( $tableset as $key => $SQL ) {
	$progress[$key] = uss::$global['mysqli']->query( $SQL );
	$error_list[$key] = uss::$global['mysqli']->error;
};


if( in_array(false, $progress) ) {
	uss::view(function() use($error_list) { 
		$error = implode( " <hr> <i class='fas fa-caret-right me-1'></i> ", array_filter($error_list) );
	?>
		
		<div class='container-fluid bg-light vh-100'>
			<div class='row'>
				<div class='col-lg-7 my-4 mx-auto'>
							
					<div class='card shadow'>
						<div class='card-body p-5'>
							<h3 class='mb-2'>CBT Database Error:</h1>
							<p class='text-muted'>The following problem needs to be fixed to continue</p>
							<div class='errors'>
								<?php echo $error ; ?>
							</div>
						</div>
					</div>
		
				</div>
			</div>
		</div>
		
	<?php });
	exit;
};
