<?php 

events::addListener('@head::after', function() {
	$quill = core::url( CBT_DIR . '/assets/quill/quill.snow.css' );
	echo "\t<link rel='stylesheet' href='{$quill}'>\n";
});

events::addListener('@body::after', function() {
	$quill = core::url( CBT_DIR . '/assets/quill/quill.js' );
?>
	<script src='<?php echo $quill; ?>'></script>
	<script>
		$("input[data-quill], textarea[data-quill]").each(function() {
			let container = document.createElement('div');
			container.classList.add('quill-container');
			let quillbox = document.createElement('div');
			container.appendChild(quillbox);
			let self = this;
			this.after(container);
			$(this).css({
				height: 0,
				minHeight: 0,
				padding: 0,
				lineHeight: 0
			});
			quill = new Quill(quillbox, {
				theme: 'snow',
				placeholder: this.placeholder
			});
			quill.root.style.minHeight = '150px'
			quill.root.innerHTML = this.value;
			quill.on('text-change', function() {
				self.value = ( quill.root.innerHTML );
			});
		});
	</script>
<?php });


uss::$global['menu']->iterate(function($menu) {
	if( $menu->name == 'contact' ) {
		$menu->parent_menu->remove( $menu->name );
	};
});