<?php 

// Set HREF Location;

$LOCATION =  PANEL_URI . '/exams/question';


// Create Page Exams;

uss::focus( $LOCATION, function() {
	
	$prefix = DB_TABLE_PREFIX;
	
	$_GET = array_map( array( uss::$global['mysqli'], 'real_escape_string' ), $_GET );
	
	$exam = dashboard::fetch_assoc( "{$prefix}_exams", $_GET['exam'] ?? null );
	
	require __DIR__ . '/post.php';
	
	if( $exam && ($_GET['id'] ?? null) ) {
		$SQL = "
			SELECT {$prefix}_questions.*
			FROM {$prefix}_questions
			INNER JOIN {$prefix}_exams
			ON {$prefix}_questions.exam_id = {$prefix}_exams.id
			WHERE {$prefix}_questions.id = '{$_GET['id']}'
		";	
		$question = uss::$global['mysqli']->query( $SQL )->fetch_assoc();
	} else $question = [];
	
	dashboard::view(function() use($exam, $question) { 
	
		$prefix = DB_TABLE_PREFIX;
		
		$SQL = sQuery::select( "{$prefix}_subjects", "1 ORDER BY name ASC" );
		
		$subjects = uss::$global['mysqli']->query( $SQL );
		
	?>
	
		<div class='container-fluid'>
			<div class='row'>
				
				<?php if( $exam ): ?>
				
				<div class='col-lg-8 mb-4 mx-auto'>
					<div class='card'>
						<div class='card-body'>
							
							<form method='POST' enctype='multipart/form-data'>
								
								<input type='hidden' name='question[exam_id]' value='<?php echo $exam['id']; ?>'>
								<input type='hidden' name='id' value='<?php echo $question['id'] ?? null; ?>'>
								
								<div class='p-3 p-sm-5'>
								
									<?php events::exec('exam-question'); ?>
								
									<div class='mb-4'>
										<?php if( !$subjects->num_rows ): ?>
											<div class='alert alert-warning text-center text-sm'>
												Please <a href='<?php echo core::url( ROOT_DIR . "/" . PANEL_URI . "/subjects" ); ?>'>add subject</a> to continue
											</div>
										<?php endif; ?>
										<label class='form-label --required'>Subject</label>
										<select class='form-control required text-capitalize' required name='question[subject_id]'>
											<option value=''>-- select subject --</option>
											<?php 
												if( $subjects->num_rows ):
													while( $subject = $subjects->fetch_assoc() ):
														$selected = ($subject['id'] == ($question['subject_id'] ?? 0)) ? 'selected' : null;
											?>
												<option value='<?php echo $subject['id']; ?>' <?php echo $selected; ?>>
													<?php echo $subject['name']; ?>
												</option>
											<?php 
													endwhile;
												endif; 
											?>
										</select>
									</div>
								
									<div class='mb-4'>
										<label class='form-label --required'>Points</label>
										<input class='form-control' type='number' name='question[points]' step='0.1' placeholder='Marks for this question' required value='<?php echo $question['points'] ?? null; ?>'>
									</div>
								
								
									<div class='mb-4'>
										<label class='form-label --required'>Question</label>
										<textarea class='form-control' rows='8' name='question[question]' placeholder='What is the value of 1 + 1?' required data-uss-editor='snow'><?php echo $question['question'] ?? null; ?></textarea>
									</div>
								
									<div class='mb-4'>
										<label class='form-label'>Image</label>
										<?php 
											if( $question['image'] ?? null ) {
												$image = core::url( DASHBOARD_MOD_DIR . "/assets/images/{$question['image']}" );
											} else $image = null;
										?>
										<img src='<?php echo $image; ?>' class='img-fluid shadow-sm mb-2' id='Q-img'>
										<input type='file' name='image' accept='.jpg,.png,.gif,.webp,.jpeg' class='form-control' data-uss-image-preview='#Q-img'>
										<input type='hidden' name='clear-image' value='0'>
										<?php if( $image ): ?>
											<div class='form-check mt-2 user-select-none'>
												<input type='checkbox' name='clear-image' value='1' class='form-check-input' id='clr'>
												<label class='form-check-label' for='clr'>Clear Image</label>
											</div>
										<?php endif; ?>
									</div>
									
									<div class='border-top my-5'></div>
								
									<?php 
										for( $x = 1; $x <= 4; $x++ ):
										
											$id = "correct-{$x}";
											$required = ( $x < 3 ) ? 'required' : '';
											
											if( !empty( $question ) )
												$checked = $x === ((int)($question['correct']  ?? 0));
											else $checked = ( $x === 1 );
											
											$checked = $checked ? 'checked' : null;
											
											$value = $question["option{$x}"] ?? null;
											
									?>
									<div class='mb-4'>
										<textarea type='textarea' class='form-control resize-none mb-1' name='<?php echo "question[option{$x}]"; ?>' rows='2' placeholder='<?php echo "Answer {$x}"; ?>' <?php echo $required; ?>><?php echo $value; ?></textarea>
										<div class='form-check form-switch'>
											<input type='radio' class='form-check-input' name='question[correct]' value='<?php echo $x; ?>' id='<?php echo $id; ?>' <?php echo $checked ?>>
											<label class='form-check-label' for='<?php echo $id; ?>'>Correct</label>
										</div>
									</div>
									<?php endfor; ?>
									
									<div class='mb-4 border-top invisible'></div>
									
									<div class=''>
										<button class='btn btn-primary w-100'>
											Submit
										</button>
									</div>
								
								</div>
							
							</form>
						
						</div>
					</div>
				</div>
				
				<?php else: ?>
				
					<div class='col-lg-8 col-10 m-auto'>
						<div class='my-5 text-center text-uppercase'>
							<h1 class='display-3 mb-4'>
								No Exam Data Found Here
							</h1>
							<a href='./' class='btn btn-secondary btn-lg w-100'>
								Go Back
							</a>
						</div>
					</div>
				
				<?php endif; ?>
			
			</div>
		</div>
	
	<?php });
	
});