<?php 

// Set HREF Location;

$LOCATION =  PANEL_URI . '/grades/new';

uss::$global['menu']->get('grades')->add('new', array(
	'label' => 'Add new',
	'href' => core::url( ROOT_DIR . "/{$LOCATION}" ),
	'active' => $_GET['query'] == $LOCATION
));

// Create Page Exams;

uss::focus( $LOCATION, function() {
	
	$prefix = DB_TABLE_PREFIX;
	
	require __DIR__ . '/post.php';
	
	$grade = dashboard::fetch_assoc( "{$prefix}_grades", ($_GET['id'] ?? 0) );
	
	if( !$grade ) $grade = [];
	
	dashboard::view(function() use($grade) { ?>
	
		<div class='container-fluid'>
			<div class='row'>
			
				<div class='col-sm-6 col-lg-5 col-xl-4 mx-auto'>
				
					<?php events::exec( '--alert' ); ?>
					
					<div class='card'>
						<div class='card-body'>
							
							<div class='p-3'>
								
								<form method='POST'>
								
									<div class='mb-3'>
										<label class='form-label'>From <span class='text-muted'>(%)</span></label>
										<input type='number' name='_from' class='form-control' placeholder='E.g 20' required value='<?php echo $grade['_from'] ?? null; ?>' min='0'>
									</div>
								
									<div class='mb-3'>
										<label class='form-label'>To <span class='text-muted'>(%)</span></label>
										<input type='number' name='_to' class='form-control' placeholder='E.g 60' required max='100' value='<?php echo $grade['_to'] ?? null; ?>'>
									</div>
								
									<div class='mb-3'>
										<label class='form-label'>Grade Name</label>
										<input type='text' name='_name' class='form-control' placeholder='E.g Excellent' required value='<?php echo $grade['_name'] ?? null; ?>'>
									</div>
								
									<div class='mb-3'>
										<label class='form-label'>Grade Type</label>
										<input type='text' name='_type' class='form-control' placeholder='E.g A' required value='<?php echo $grade['_type'] ?? null; ?>'>
									</div>
								
									<input type='hidden' name='id' value='<?php echo $grade['id'] ?? null; ?>'>
									
									<div class='mb-3'>
										<button class='btn btn-primary w-100' type='submit'>
											<?php echo empty($grade) ? 'Add' : 'Update'; ?> Grade
										</button>
									</div>
									
								</form>	
							
							</div>
						
						</div>
					</div>
				</div>
			
			</div>
		</div>
	
	<?php });
	
});