<?php 

// Set HREF Location;

$LOCATION =  PANEL_URI . '/grades';


// Set Page Menu;

uss::$global['menu']->add('grades', array(
	'label' => 'Grades',
	'icon' => "<i class='bi bi-mortarboard'></i>",
	'active' => preg_match( "~{$LOCATION}~", $_GET['query'] )
));


uss::$global['menu']->get('grades')->add('list', array(
	'label' => 'View all',
	'href' => core::url( ROOT_DIR . "/{$LOCATION}" ),
	'active' => $_GET['query'] == $LOCATION
));


// Create Page Exams;

uss::focus( $LOCATION, function() {
	
	$prefix = DB_TABLE_PREFIX;
	
	require __DIR__ . '/post.php';
	
	$SQL = sQuery::select( "{$prefix}_grades", "1 ORDER BY _from DESC" );
	
	$grades = uss::$global['mysqli']->query( $SQL );
	
	// -- [ table ] --
	
	$table = new DOMTablet( 'grades' );
	
	$table->data( $grades );
	
	$table->columns(array(
		"_from" => "From",
		"_to" => "To",
		"_name" => "Name",
		"_type" => "Type",
		"action" => "Action"
	), true);
	
	dashboard::view(function() use($table) { ?>
	
		<div class='container-fluid'>
			
			<div class='row'>
			
				<div class='col-lg-12'>
					<div class='card'>
						<div class='card-body'>
						
							<?php echo $table->prepare(function($data) {
								$data['_from'] = "{$data['_from']}%";
								$data['_to'] = "{$data['_to']}%";
								$data['action'] = "
									<a href='./grades/new?id={$data['id']}' class='btn btn-primary btn-sm mb-1'>
										<i class='bi bi-pencil'></i> 
									</a>
									<a href='?delete={$data['id']}' data-uss-confirm='Are you sure you want to delete this grade?' class='btn btn-danger btn-sm mb-1'>
										<i class='bi bi-trash'></i> 
									</a>
								";
								return $data;
							}); ?>
						
						</div>
					</div>
				</div>
			
			</div>
		</div>
	
	<?php });
	
});