<?php 

// Set HREF Location;

$LOCATION =  PANEL_URI . '/departments';

// Set Page Menu;

uss::$global['menu']->add('department', array(
	'label' => 'Departments',
	'href' => core::url( ROOT_DIR . "/{$LOCATION}" ),
	'icon' => "<i class='bi bi-database'></i>"
))->set_attr('active', $_GET['query'] == $LOCATION);


// Create Page Exams;

uss::focus( $LOCATION, function() {
	
	$prefix = DB_TABLE_PREFIX;
	
	require __DIR__ . '/post.php';
	
	// QUERY;
	
	$SQL = sQuery::select( "{$prefix}_departments", "1 ORDER BY name" );
	
	$query = uss::$global['mysqli']->query( $SQL );
	
	// TABLE;
	
	$table = new DOMTablet( 'department' );
	
	$table->data( $query );
	
	$table->columns(array(
		"name" => "department",
		"actions" => ''
	));
	
	$table->wrap();
	
	dashboard::view(function() use($table, $department) { 
		
	?>
	
		<div class='container-fluid'>
			<div class='row'>
				
				<div class='col-md-10 col-lg-9'>
					<form method='POST' action='?'>
						<?php if( !empty($department['id']) ): ?>
							<a href='?' class='text-sm py-1 d-inline-block'> 
								<i class='bi bi-x text-danger me-1'></i> Cancel Update
							</a>
						<?php endif; ?>
						<div class='row'>
							<div class='col-md-7 mb-2'>
								<input type='text' class='form-control' placeholder='E.g Science' name='department' value='<?php echo $department['name'] ?? null; ?>' required>
							</div>
							<input type='hidden' name='id' value='<?php echo $department['id'] ?? null; ?>'>
							<div class='col-md-4'>
								<button class='btn btn-success mb-3 text-sm'>
									<?php echo !($department['id'] ?? null) ? 'Add <i class="ms-1 bi bi-plus-circle"></i>' : 'Update <i class="ms-1 bi bi-check-circle"></i>'; ?>
								</button>
							</div>
						</div>
					</form>
				</div>
				
				<div class='col-lg-12'>
					<?php 
						$table->prepare(function($data) {
							$data['actions'] = "
								<form method='GET' class='text-end' data-uss-confirm='Are you sure you want to delete the department?'>
									<input type='hidden' name='id' value='{$data['id']}'>
									<a href='?req=edit&id={$data['id']}' class='btn btn-primary btn-sm'>
										<i class='bi bi-pencil'></i>
									</a>
									<button name='req' value='delete' class='btn btn-danger btn-sm'>
										<i class='bi bi-trash'></i>
									</button>
								</div>
							";
							return $data;
						}, true);
					?>
				</div>
			
			</div>
		</div>
	
	<?php });
	
});